# Listing 1: Ein `<picture>`-Tag bietet dem Browser verschiedene Bildgrößen an
```html
<picture>
  <source
	srcset="image-large-2x.jpg 2x, image-large.jpg"
	media="(min-width: 1024px)"
  >
  <source
    srcset="image-medium-2x.jpg 2x, image-medium.jpg"
    media="(min-width: 768px)"
  >
  <img
    src="image-small.jpg"
    srcset="image-small.jpg 2x"
    width="400"
    height="300"
    alt="Bildbeschreibung"
  >
</picture>
```

# Listing 2: Ein Bild wird dem Browser in mehreren Formaten angeboten
```html
<picture>
  <source srcset="image.avif" type="image/avif">
  <source srcset="image.webp" type="image/webp">
  <source srcset="image.jpeg" type="image/jpeg">
  <img src="image.png" width="400" height="300" alt="Bildbeschreibung">
</picture>
```

# Listing 3: Beispiel eines responsiven Preload-Hints für ein Bild
```html
<html>
<head>
  <link
    rel="preload"
    as="image"
    imagesrcset="
      image-320.jpg 320w,
      image-500.jpg 500w,
      image-768.jpg 768w,
      image-1024.jpg 1024w
    "
    imagesizes="100vw"
  >
</head>
<body>
  <img
    srcset="
      image-320.jpg 320w,
      image-500.jpg 500w,
      image-768.jpg 768w,
      image-1024.jpg 1024w
    "
    sizes="100vw"
    width="400"
    height="300"
    alt="Bildbeschreibung"
  >
</body>
</html>
```
